/**
* \file: DummyMediaPlaybackStatus.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <string>

#include "DummyMediaPlaybackStatus.h"
#include "DummyMediaPlaybackStatusImpl.h"

LOG_IMPORT_CONTEXT(aauto_media_pb_status)

namespace adit { namespace aauto {
using std::string;

DummyMediaPlaybackStatus::DummyMediaPlaybackStatus(uint8_t inSessionId, MessageRouter* inMessageRouter) :
                                AditMediaPlaybackStatus(inSessionId, inMessageRouter)
{
    impl = new DummyMediaPlaybackStatusImpl(this, (void*) inMessageRouter);
}

DummyMediaPlaybackStatus::~DummyMediaPlaybackStatus()
{
    /* impl id deleted at GalReceiver destruction,
     * it is registered as a callback and hold in a shared pointer */
}

void DummyMediaPlaybackStatus::setConfigItem(string inKey, string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

void DummyMediaPlaybackStatus::registerCallbacks(
        IAditMediaPlaybackStatusCallbacks* inCallbacks)
{
    impl->registerCallbacks(inCallbacks);
}

bool DummyMediaPlaybackStatus::init()
{
    LOG_INFO((aauto_media_pb_status, "test media playback status initialize"));
    return impl->init();
}

void DummyMediaPlaybackStatus::shutdown()
{
    LOG_INFO((aauto_media_pb_status, "test media playback status shut down"));
    impl->shutdown();
}

} } /* namespace adit { namespace aauto { */
